# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ConnectionGatewayAuthentication(UniversalBaseModel):
    """
    Token-based authentication settings to be applied when connection is using an sms strategy.
    """

    method: str = pydantic.Field()
    """
    The Authorization header type.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subject to be added to the JWT payload.
    """

    audience: str = pydantic.Field()
    """
    The audience to be added to the JWT payload.
    """

    secret: str = pydantic.Field()
    """
    The secret to be used for signing tokens.
    """

    secret_base_64_encoded: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="secret_base64_encoded")
    ] = pydantic.Field(default=None)
    """
    Set to true if the provided secret is base64 encoded.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
