# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .connection_options_common import ConnectionOptionsCommon
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_upstream_params import ConnectionUpstreamParams


class ConnectionOptionsApple(ConnectionOptionsCommon):
    """
    Options for the 'apple' connection
    """

    app_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Apple App Secret (must be a PEM)
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Apple Services ID
    """

    email: typing.Optional[bool] = pydantic.Field(default=None)
    """
    User has the option to obfuscate the email with Apple's relay service
    """

    freeform_scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Array of freeform scopes
    """

    kid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Apple Key ID
    """

    name: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to request name from Apple
    """

    scope: typing.Optional[str] = pydantic.Field(default=None)
    """
    Space separated list of scopes
    """

    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    team_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Apple Team ID
    """

    upstream_params: typing.Optional[ConnectionUpstreamParams] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
