# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .connection_attributes import ConnectionAttributes
from .connection_authentication_methods import ConnectionAuthenticationMethods
from .connection_brute_force_protection import ConnectionBruteForceProtection
from .connection_configuration import ConnectionConfiguration
from .connection_custom_scripts import ConnectionCustomScripts
from .connection_disable_self_service_change_password import ConnectionDisableSelfServiceChangePassword
from .connection_disable_signup import ConnectionDisableSignup
from .connection_enable_script_context import ConnectionEnableScriptContext
from .connection_enabled_database_customization import ConnectionEnabledDatabaseCustomization
from .connection_identifier_precedence import ConnectionIdentifierPrecedence
from .connection_import_mode import ConnectionImportMode
from .connection_mfa import ConnectionMfa
from .connection_options_common import ConnectionOptionsCommon
from .connection_passkey_options import ConnectionPasskeyOptions
from .connection_password_complexity_options import ConnectionPasswordComplexityOptions
from .connection_password_dictionary_options import ConnectionPasswordDictionaryOptions
from .connection_password_history_options import ConnectionPasswordHistoryOptions
from .connection_password_no_personal_info_options import ConnectionPasswordNoPersonalInfoOptions
from .connection_password_policy_enum import ConnectionPasswordPolicyEnum
from .connection_realm_fallback import ConnectionRealmFallback
from .connection_requires_username import ConnectionRequiresUsername
from .connection_validation_options import ConnectionValidationOptions


class ConnectionOptionsAuth0(ConnectionOptionsCommon):
    """
    Options for the 'auth0' connection
    """

    attributes: typing.Optional[ConnectionAttributes] = None
    authentication_methods: typing.Optional[ConnectionAuthenticationMethods] = None
    brute_force_protection: typing.Optional[ConnectionBruteForceProtection] = None
    configuration: typing.Optional[ConnectionConfiguration] = None
    custom_scripts: typing_extensions.Annotated[
        typing.Optional[ConnectionCustomScripts], FieldMetadata(alias="customScripts")
    ] = None
    disable_self_service_change_password: typing.Optional[ConnectionDisableSelfServiceChangePassword] = None
    disable_signup: typing.Optional[ConnectionDisableSignup] = None
    enable_script_context: typing.Optional[ConnectionEnableScriptContext] = None
    enabled_database_customization: typing_extensions.Annotated[
        typing.Optional[ConnectionEnabledDatabaseCustomization], FieldMetadata(alias="enabledDatabaseCustomization")
    ] = None
    import_mode: typing.Optional[ConnectionImportMode] = None
    mfa: typing.Optional[ConnectionMfa] = None
    passkey_options: typing.Optional[ConnectionPasskeyOptions] = None
    password_policy: typing_extensions.Annotated[
        typing.Optional[ConnectionPasswordPolicyEnum], FieldMetadata(alias="passwordPolicy")
    ] = None
    password_complexity_options: typing.Optional[ConnectionPasswordComplexityOptions] = None
    password_dictionary: typing.Optional[ConnectionPasswordDictionaryOptions] = None
    password_history: typing.Optional[ConnectionPasswordHistoryOptions] = None
    password_no_personal_info: typing.Optional[ConnectionPasswordNoPersonalInfoOptions] = None
    precedence: typing.Optional[ConnectionIdentifierPrecedence] = None
    realm_fallback: typing.Optional[ConnectionRealmFallback] = None
    requires_username: typing.Optional[ConnectionRequiresUsername] = None
    validation: typing.Optional[ConnectionValidationOptions] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
