# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .connection_app_domain_azure_ad import ConnectionAppDomainAzureAd
from .connection_client_id_azure_ad import ConnectionClientIdAzureAd
from .connection_client_secret_azure_ad import ConnectionClientSecretAzureAd
from .connection_domain_aliases_azure_ad import ConnectionDomainAliasesAzureAd
from .connection_ext_admin import ConnectionExtAdmin
from .connection_ext_agreed_terms import ConnectionExtAgreedTerms
from .connection_ext_assigned_plans import ConnectionExtAssignedPlans
from .connection_ext_groups import ConnectionExtGroups
from .connection_ext_is_suspended import ConnectionExtIsSuspended
from .connection_ext_profile import ConnectionExtProfile
from .connection_federated_connections_access_tokens import ConnectionFederatedConnectionsAccessTokens
from .connection_icon_url_azure_ad import ConnectionIconUrlAzureAd
from .connection_identity_api_azure_ad import ConnectionIdentityApiAzureAd
from .connection_max_groups_to_retrieve import ConnectionMaxGroupsToRetrieve
from .connection_options_common import ConnectionOptionsCommon
from .connection_scope_azure_ad import ConnectionScopeAzureAd
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_should_trust_email_verified_connection_enum import ConnectionShouldTrustEmailVerifiedConnectionEnum
from .connection_tenant_domain_azure_ad_one import ConnectionTenantDomainAzureAdOne
from .connection_tenant_id_azure_ad import ConnectionTenantIdAzureAd
from .connection_thumbprints import ConnectionThumbprints
from .connection_upstream_params_azure_ad import ConnectionUpstreamParamsAzureAd
from .connection_use_common_endpoint_azure_ad import ConnectionUseCommonEndpointAzureAd
from .connection_userid_attribute_azure_ad import ConnectionUseridAttributeAzureAd
from .connection_waad_protocol import ConnectionWaadProtocol


class ConnectionOptionsAzureAd(ConnectionOptionsCommon):
    """
    Options for the 'waad' connection
    """

    api_enable_users: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enable users API
    """

    app_domain: typing.Optional[ConnectionAppDomainAzureAd] = None
    app_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Application ID URI (App ID URI) for the Azure AD application. Required when using Azure AD v1 with the Resource Owner Password flow. Used to identify the resource being requested in OAuth token requests.
    """

    basic_profile: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Includes basic user profile information from Azure AD (name, email, given_name, family_name). Always enabled and required - represents the minimum profile data retrieved during authentication.
    """

    client_id: typing.Optional[ConnectionClientIdAzureAd] = None
    client_secret: typing.Optional[ConnectionClientSecretAzureAd] = None
    domain_aliases: typing.Optional[ConnectionDomainAliasesAzureAd] = None
    ext_access_token: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's Azure AD access token in the Auth0 user profile. When true (default), the access token is persisted for API access.
    """

    ext_account_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing whether the user's Azure AD account is enabled. When true (default), the account enabled status is persisted in the user profile.
    """

    ext_admin: typing.Optional[ConnectionExtAdmin] = None
    ext_agreed_terms: typing.Optional[ConnectionExtAgreedTerms] = None
    ext_assigned_licenses: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the list of Microsoft 365/Office 365 licenses assigned to the user. When true (default), license information is persisted in the user profile.
    """

    ext_assigned_plans: typing.Optional[ConnectionExtAssignedPlans] = None
    ext_azure_id: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's Azure ID identifier. When true (default), the Azure ID is persisted. Note: 'oid' (Object ID) is the recommended unique identifier for single-tenant connections.
    """

    ext_city: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's city from Azure AD. When true (default), city information is persisted in the user profile.
    """

    ext_country: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's country from Azure AD. When true (default), country information is persisted in the user profile.
    """

    ext_department: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's department from Azure AD. When true (default), department information is persisted in the user profile.
    """

    ext_dir_sync_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing whether directory synchronization is enabled for the user. When true (default), directory sync status is persisted in the user profile.
    """

    ext_email: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's email address from Azure AD. When true (default), email is persisted in the user profile.
    """

    ext_expires_in: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the token expiration time (in seconds). When true (default), expiration information is persisted in the user profile.
    """

    ext_family_name: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's family name (last name) from Azure AD. When true (default), family name is persisted in the user profile.
    """

    ext_fax: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's fax number from Azure AD. When true (default), fax information is persisted in the user profile.
    """

    ext_given_name: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's given name (first name) from Azure AD. When true (default), given name is persisted in the user profile.
    """

    ext_group_ids: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the list of Azure AD group IDs the user is a member of. When true (default), group membership IDs are persisted. See ext_groups for retrieving group details.
    """

    ext_groups: typing.Optional[ConnectionExtGroups] = None
    ext_is_suspended: typing.Optional[ConnectionExtIsSuspended] = None
    ext_job_title: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's job title from Azure AD. When true (default), job title information is persisted in the user profile.
    """

    ext_last_sync: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the timestamp of the last directory synchronization. When true (default), the last sync date is persisted in the user profile.
    """

    ext_mobile: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's mobile phone number from Azure AD. When true (default), mobile number is persisted in the user profile.
    """

    ext_name: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's full name from Azure AD. When true (default), full name is persisted in the user profile.
    """

    ext_nested_groups: typing.Optional[bool] = pydantic.Field(default=False)
    """
    When true, stores all groups the user is member of, including transitive group memberships (groups within groups). When false (default), only direct group memberships are included.
    """

    ext_nickname: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's nickname or display name from Azure AD. When true (default), nickname is persisted in the user profile.
    """

    ext_oid: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's Object ID (oid) from Azure AD. When true (default), the oid is persisted. Note: 'oid' is the recommended unique identifier for single-tenant connections and required for SCIM.
    """

    ext_phone: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's phone number from Azure AD. When true (default), phone number is persisted in the user profile.
    """

    ext_physical_delivery_office_name: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's office location from Azure AD. When true (default), office location is persisted in the user profile.
    """

    ext_postal_code: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's postal code from Azure AD. When true (default), postal code is persisted in the user profile.
    """

    ext_preferred_language: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's preferred language from Azure AD. When true (default), language preference is persisted in the user profile.
    """

    ext_profile: typing.Optional[ConnectionExtProfile] = None
    ext_provisioned_plans: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the list of service plans provisioned to the user. When true (default), provisioned plans are persisted in the user profile.
    """

    ext_provisioning_errors: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing provisioning errors that occurred during synchronization. When true (default), error information is persisted. Useful for troubleshooting sync issues.
    """

    ext_proxy_addresses: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing all proxy email addresses (email aliases) for the user. When true (default), proxy addresses are persisted in the user profile.
    """

    ext_puid: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's Passport User ID (puid). When true (default), puid is persisted in the user profile. Legacy attribute.
    """

    ext_refresh_token: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the Azure AD refresh token. When true (default), the refresh token is persisted for offline access. Required for token refresh in long-lived applications.
    """

    ext_roles: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing Azure AD application roles assigned to the user. When true (default), role information is persisted. Useful for RBAC in applications.
    """

    ext_state: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's state (province/region) from Azure AD. When true (default), state information is persisted in the user profile.
    """

    ext_street: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's street address from Azure AD. When true (default), street address is persisted in the user profile.
    """

    ext_telephone_number: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="ext_telephoneNumber")
    ] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's telephone number from Azure AD. When true (default), telephone number is persisted in the user profile.
    """

    ext_tenantid: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's Azure AD tenant ID. When true (default), tenant ID is persisted. Useful for identifying which Azure AD organization the user belongs to.
    """

    ext_upn: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's User Principal Name (UPN) from Azure AD. When true (default), UPN is persisted. UPN is the user's logon name (e.g., user@contoso.com).
    """

    ext_usage_location: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing the user's usage location for license assignment. When true (default), usage location is persisted in the user profile.
    """

    ext_user_id: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When false, prevents storing an alternative user ID. When true (default), this user ID is persisted in the user profile.
    """

    federated_connections_access_tokens: typing.Optional[ConnectionFederatedConnectionsAccessTokens] = None
    granted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether admin consent has been granted for the required Azure AD permissions. Read-only status field managed by Auth0 during the OAuth authorization flow.
    """

    icon_url: typing.Optional[ConnectionIconUrlAzureAd] = None
    identity_api: typing.Optional[ConnectionIdentityApiAzureAd] = None
    max_groups_to_retrieve: typing.Optional[ConnectionMaxGroupsToRetrieve] = None
    scope: typing.Optional[ConnectionScopeAzureAd] = None
    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    should_trust_email_verified_connection: typing.Optional[ConnectionShouldTrustEmailVerifiedConnectionEnum] = None
    tenant_domain: typing.Optional[ConnectionTenantDomainAzureAdOne] = None
    tenant_id: typing_extensions.Annotated[
        typing.Optional[ConnectionTenantIdAzureAd], FieldMetadata(alias="tenantId")
    ] = None
    thumbprints: typing.Optional[ConnectionThumbprints] = None
    upstream_params: typing.Optional[ConnectionUpstreamParamsAzureAd] = None
    use_wsfed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates WS-Federation protocol usage. When true, uses WS-Federation; when false, uses OpenID Connect.
    """

    use_common_endpoint: typing_extensions.Annotated[
        typing.Optional[ConnectionUseCommonEndpointAzureAd], FieldMetadata(alias="useCommonEndpoint")
    ] = None
    userid_attribute: typing.Optional[ConnectionUseridAttributeAzureAd] = None
    waad_protocol: typing.Optional[ConnectionWaadProtocol] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
