# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection_authorization_endpoint import ConnectionAuthorizationEndpoint
from .connection_client_id_oidc import ConnectionClientIdOidc
from .connection_client_secret_oidc import ConnectionClientSecretOidc
from .connection_connection_settings import ConnectionConnectionSettings
from .connection_domain_aliases_one import ConnectionDomainAliasesOne
from .connection_federated_connections_access_tokens import ConnectionFederatedConnectionsAccessTokens
from .connection_icon_url import ConnectionIconUrl
from .connection_id_token_signed_response_algs import ConnectionIdTokenSignedResponseAlgs
from .connection_issuer import ConnectionIssuer
from .connection_jwks_uri import ConnectionJwksUri
from .connection_options_oidc_metadata import ConnectionOptionsOidcMetadata
from .connection_scope_oidc import ConnectionScopeOidc
from .connection_send_back_channel_nonce import ConnectionSendBackChannelNonce
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_tenant_domain import ConnectionTenantDomain
from .connection_token_endpoint_auth_method_enum import ConnectionTokenEndpointAuthMethodEnum
from .connection_token_endpoint_auth_signing_alg_enum import ConnectionTokenEndpointAuthSigningAlgEnum
from .connection_token_endpoint_oidc import ConnectionTokenEndpointOidc
from .connection_upstream_params_oidc import ConnectionUpstreamParamsOidc
from .connection_userinfo_endpoint_oidc import ConnectionUserinfoEndpointOidc


class ConnectionOptionsCommonOidc(UniversalBaseModel):
    """
    common options for OIDC connections
    """

    authorization_endpoint: typing.Optional[ConnectionAuthorizationEndpoint] = None
    client_id: ConnectionClientIdOidc
    client_secret: typing.Optional[ConnectionClientSecretOidc] = None
    connection_settings: typing.Optional[ConnectionConnectionSettings] = None
    federated_connections_access_tokens: typing.Optional[ConnectionFederatedConnectionsAccessTokens] = None
    domain_aliases: typing.Optional[ConnectionDomainAliasesOne] = None
    icon_url: typing.Optional[ConnectionIconUrl] = None
    id_token_signed_response_algs: typing.Optional[ConnectionIdTokenSignedResponseAlgs] = None
    issuer: typing.Optional[ConnectionIssuer] = None
    jwks_uri: typing.Optional[ConnectionJwksUri] = None
    oidc_metadata: typing.Optional[ConnectionOptionsOidcMetadata] = None
    scope: typing.Optional[ConnectionScopeOidc] = None
    send_back_channel_nonce: typing.Optional[ConnectionSendBackChannelNonce] = None
    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    tenant_domain: typing.Optional[ConnectionTenantDomain] = None
    token_endpoint: typing.Optional[ConnectionTokenEndpointOidc] = None
    token_endpoint_auth_method: typing.Optional[ConnectionTokenEndpointAuthMethodEnum] = None
    token_endpoint_auth_signing_alg: typing.Optional[ConnectionTokenEndpointAuthSigningAlgEnum] = None
    upstream_params: typing.Optional[ConnectionUpstreamParamsOidc] = None
    userinfo_endpoint: typing.Optional[ConnectionUserinfoEndpointOidc] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
