# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .connection_allowed_audiences_google_o_auth_2 import ConnectionAllowedAudiencesGoogleOAuth2
from .connection_client_id_google_o_auth_2 import ConnectionClientIdGoogleOAuth2
from .connection_client_secret_google_o_auth_2 import ConnectionClientSecretGoogleOAuth2
from .connection_freeform_scopes_google_o_auth_2 import ConnectionFreeformScopesGoogleOAuth2
from .connection_icon_url_google_o_auth_2 import ConnectionIconUrlGoogleOAuth2
from .connection_options_common import ConnectionOptionsCommon
from .connection_scope_google_o_auth_2 import ConnectionScopeGoogleOAuth2
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_upstream_params import ConnectionUpstreamParams


class ConnectionOptionsGoogleOAuth2(ConnectionOptionsCommon):
    """
    Options for the 'google-oauth2' connection
    """

    adsense_management: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's ad applications, ad units, and channels in AdSense
    """

    allowed_audiences: typing.Optional[ConnectionAllowedAudiencesGoogleOAuth2] = None
    analytics: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View user's configuration information and reports
    """

    blogger: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's posts and blogs on Blogger and Blogger comments
    """

    calendar: typing.Optional[bool] = pydantic.Field(default=None)
    """
    See, edit, share, and permanently delete all the calendars you can access using Google Calendar
    """

    calendar_addons_execute: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Run as a Calendar add-on
    """

    calendar_events: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and edit events on all your calendars
    """

    calendar_events_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View events on all your calendars
    """

    calendar_settings_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View your Calendar settings
    """

    chrome_web_store: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read access to user's chrome web store
    """

    client_id: typing.Optional[ConnectionClientIdGoogleOAuth2] = None
    client_secret: typing.Optional[ConnectionClientSecretGoogleOAuth2] = None
    contacts: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to the authenticated user's contacts
    """

    contacts_new: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to the authenticated user's contacts
    """

    contacts_other_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to the authenticated user's 'Other contacts'
    """

    contacts_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to the authenticated user's contacts
    """

    content_api_for_shopping: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's products, feeds, and subaccounts
    """

    coordinate: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Grants read and write access to the Coordinate API
    """

    coordinate_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Grants read access to the Coordinate API
    """

    directory_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to the authenticated user's corporate directory (if applicable)
    """

    document_list: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Access to Google Docs document list feed
    """

    drive: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to all files and folders in the user's Google Drive
    """

    drive_activity: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and add to the activity record of files in your Drive
    """

    drive_activity_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View the activity record of files in your Drive
    """

    drive_appdata: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Access to the application's configuration data in the user's Google Drive
    """

    drive_apps_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View apps authorized to access your Drive
    """

    drive_file: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Access to files created or opened by the app
    """

    drive_metadata: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Access to file metadata, including listing files and folders
    """

    drive_metadata_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to file metadata
    """

    drive_photos_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to the user's Google Photos
    """

    drive_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to all files and folders in the user's Google Drive
    """

    drive_scripts: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Modify the behavior of Google Apps Scripts
    """

    email: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Email and verified email flag
    """

    freeform_scopes: typing.Optional[ConnectionFreeformScopesGoogleOAuth2] = None
    gmail: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to the account's mailboxes, including permanent deletion of threads and messages
    """

    gmail_compose: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read all resources and their metadata—no write operations
    """

    gmail_insert: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Insert and import messages only
    """

    gmail_labels: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Create, read, update, and delete labels only
    """

    gmail_metadata: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read resources metadata including labels, history records, and email message headers, but not the message body or attachments
    """

    gmail_modify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    All read/write operations except immediate, permanent deletion of threads and messages, bypassing Trash
    """

    gmail_new: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to the account's mailboxes, including permanent deletion of threads and messages
    """

    gmail_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read all resources and their metadata—no write operations
    """

    gmail_send: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Send messages only. No read or modify privileges on mailbox
    """

    gmail_settings_basic: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Manage basic mail settings
    """

    gmail_settings_sharing: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Manage sensitive mail settings, including forwarding rules and aliases. Note: Operations guarded by this scope are restricted to administrative use only
    """

    google_affiliate_network: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's publisher data in the Google Affiliate Network
    """

    google_books: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's books and library in Google Books
    """

    google_cloud_storage: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's data stored in Google Cloud Storage
    """

    google_drive: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to all files and folders in the user's Google Drive
    """

    google_drive_files: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Access to files created or opened by the app
    """

    google_plus: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Associate user with its public Google profile
    """

    icon_url: typing.Optional[ConnectionIconUrlGoogleOAuth2] = None
    latitude_best: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's best-available current location and location history in Google Latitude
    """

    latitude_city: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's city-level current location and location history in Google Latitude
    """

    moderator: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's votes, topics, and submissions
    """

    offline_access: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Request a refresh token when the user authorizes your application
    """

    orkut: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's friends, applications and profile and status
    """

    picasa_web: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's Google photos, videos, photo and video tags and comments
    """

    profile: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Name, public profile URL, photo, country, language, and timezone
    """

    scope: typing.Optional[ConnectionScopeGoogleOAuth2] = None
    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    sites: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's sites on Google Sites
    """

    tasks: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Full access to create, edit, organize, and delete all your tasks
    """

    tasks_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Read-only access to view your tasks and task lists
    """

    upstream_params: typing.Optional[ConnectionUpstreamParams] = None
    url_shortener: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View, manage and view statistics user's short URLs
    """

    webmaster_tools: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage user's sites and messages, view keywords
    """

    youtube: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Manage your YouTube account
    """

    youtube_channelmemberships_creator: typing.Optional[bool] = pydantic.Field(default=None)
    """
    See a list of your current active channel members, their current level, and when they became a member
    """

    youtube_new: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Manage your YouTube account
    """

    youtube_readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View your YouTube account
    """

    youtube_upload: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Manage your YouTube videos
    """

    youtubepartner: typing.Optional[bool] = pydantic.Field(default=None)
    """
    View and manage your assets and associated content on YouTube
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
