# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .connection_auth_params_map import ConnectionAuthParamsMap
from .connection_auth_params_o_auth_2 import ConnectionAuthParamsOAuth2
from .connection_authorization_endpoint_o_auth_2 import ConnectionAuthorizationEndpointOAuth2
from .connection_client_id_o_auth_2 import ConnectionClientIdOAuth2
from .connection_client_secret_o_auth_2 import ConnectionClientSecretOAuth2
from .connection_custom_headers_o_auth_2 import ConnectionCustomHeadersOAuth2
from .connection_end_session_endpoint_o_auth_2 import ConnectionEndSessionEndpointOAuth2
from .connection_fields_map import ConnectionFieldsMap
from .connection_icon_url import ConnectionIconUrl
from .connection_options_common import ConnectionOptionsCommon
from .connection_scope_o_auth_2 import ConnectionScopeOAuth2
from .connection_scripts_o_auth_2 import ConnectionScriptsOAuth2
from .connection_set_user_root_attributes_enum import ConnectionSetUserRootAttributesEnum
from .connection_token_endpoint_o_auth_2 import ConnectionTokenEndpointOAuth2
from .connection_upstream_params import ConnectionUpstreamParams


class ConnectionOptionsOAuth2(ConnectionOptionsCommon):
    """
    Options for the 'oauth2' connection
    """

    auth_params: typing_extensions.Annotated[
        typing.Optional[ConnectionAuthParamsOAuth2], FieldMetadata(alias="authParams")
    ] = None
    auth_params_map: typing_extensions.Annotated[
        typing.Optional[ConnectionAuthParamsMap], FieldMetadata(alias="authParamsMap")
    ] = None
    authorization_url: typing_extensions.Annotated[
        typing.Optional[ConnectionAuthorizationEndpointOAuth2], FieldMetadata(alias="authorizationURL")
    ] = None
    client_id: typing.Optional[ConnectionClientIdOAuth2] = None
    client_secret: typing.Optional[ConnectionClientSecretOAuth2] = None
    custom_headers: typing_extensions.Annotated[
        typing.Optional[ConnectionCustomHeadersOAuth2], FieldMetadata(alias="customHeaders")
    ] = None
    fields_map: typing_extensions.Annotated[typing.Optional[ConnectionFieldsMap], FieldMetadata(alias="fieldsMap")] = (
        None
    )
    icon_url: typing.Optional[ConnectionIconUrl] = None
    logout_url: typing_extensions.Annotated[
        typing.Optional[ConnectionEndSessionEndpointOAuth2], FieldMetadata(alias="logoutUrl")
    ] = None
    pkce_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, enables Proof Key for Code Exchange (PKCE) for the authorization code flow. PKCE provides additional security by preventing authorization code interception attacks.
    """

    scope: typing.Optional[ConnectionScopeOAuth2] = None
    scripts: typing.Optional[ConnectionScriptsOAuth2] = None
    set_user_root_attributes: typing.Optional[ConnectionSetUserRootAttributesEnum] = None
    token_url: typing_extensions.Annotated[
        typing.Optional[ConnectionTokenEndpointOAuth2], FieldMetadata(alias="tokenURL")
    ] = None
    upstream_params: typing.Optional[ConnectionUpstreamParams] = None
    use_oauth_spec_scope: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="useOauthSpecScope")
    ] = pydantic.Field(default=None)
    """
    When true, uses space-delimited scopes (per OAuth 2.0 spec) instead of comma-delimited when calling the identity provider's authorization endpoint. Only relevant when using the connection_scope parameter. See https://auth0.com/docs/authenticate/identity-providers/adding-scopes-for-an-external-idp#pass-scopes-to-authorize-endpoint
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
