# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection_acr_values_supported import ConnectionAcrValuesSupported
from .connection_authorization_endpoint import ConnectionAuthorizationEndpoint
from .connection_claim_types_supported import ConnectionClaimTypesSupported
from .connection_claims_locales_supported import ConnectionClaimsLocalesSupported
from .connection_claims_parameter_supported import ConnectionClaimsParameterSupported
from .connection_claims_supported import ConnectionClaimsSupported
from .connection_display_values_supported import ConnectionDisplayValuesSupported
from .connection_end_session_endpoint import ConnectionEndSessionEndpoint
from .connection_grant_types_supported import ConnectionGrantTypesSupported
from .connection_id_token_encryption_alg_values_supported import ConnectionIdTokenEncryptionAlgValuesSupported
from .connection_id_token_encryption_enc_values_supported import ConnectionIdTokenEncryptionEncValuesSupported
from .connection_id_token_signing_alg_values_supported import ConnectionIdTokenSigningAlgValuesSupported
from .connection_issuer import ConnectionIssuer
from .connection_jwks_uri import ConnectionJwksUri
from .connection_op_policy_uri import ConnectionOpPolicyUri
from .connection_op_tos_uri import ConnectionOpTosUri
from .connection_registration_endpoint import ConnectionRegistrationEndpoint
from .connection_request_object_encryption_alg_values_supported import (
    ConnectionRequestObjectEncryptionAlgValuesSupported,
)
from .connection_request_object_encryption_enc_values_supported import (
    ConnectionRequestObjectEncryptionEncValuesSupported,
)
from .connection_request_object_signing_alg_values_supported import ConnectionRequestObjectSigningAlgValuesSupported
from .connection_request_parameter_supported import ConnectionRequestParameterSupported
from .connection_request_uri_parameter_supported import ConnectionRequestUriParameterSupported
from .connection_require_request_uri_registration import ConnectionRequireRequestUriRegistration
from .connection_response_modes_supported import ConnectionResponseModesSupported
from .connection_response_types_supported import ConnectionResponseTypesSupported
from .connection_scopes_supported import ConnectionScopesSupported
from .connection_service_documentation import ConnectionServiceDocumentation
from .connection_subject_types_supported import ConnectionSubjectTypesSupported
from .connection_token_endpoint import ConnectionTokenEndpoint
from .connection_token_endpoint_auth_methods_supported import ConnectionTokenEndpointAuthMethodsSupported
from .connection_token_endpoint_auth_signing_alg_values_supported import (
    ConnectionTokenEndpointAuthSigningAlgValuesSupported,
)
from .connection_ui_locales_supported import ConnectionUiLocalesSupported
from .connection_userinfo_encryption_alg_values_supported import ConnectionUserinfoEncryptionAlgValuesSupported
from .connection_userinfo_encryption_enc_values_supported import ConnectionUserinfoEncryptionEncValuesSupported
from .connection_userinfo_endpoint import ConnectionUserinfoEndpoint
from .connection_userinfo_signing_alg_values_supported import ConnectionUserinfoSigningAlgValuesSupported


class ConnectionOptionsOidcMetadata(UniversalBaseModel):
    """
    OpenID Connect Provider Metadata as per https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata
    """

    acr_values_supported: typing.Optional[ConnectionAcrValuesSupported] = None
    authorization_endpoint: ConnectionAuthorizationEndpoint
    claim_types_supported: typing.Optional[ConnectionClaimTypesSupported] = None
    claims_locales_supported: typing.Optional[ConnectionClaimsLocalesSupported] = None
    claims_parameter_supported: typing.Optional[ConnectionClaimsParameterSupported] = None
    claims_supported: typing.Optional[ConnectionClaimsSupported] = None
    display_values_supported: typing.Optional[ConnectionDisplayValuesSupported] = None
    end_session_endpoint: typing.Optional[ConnectionEndSessionEndpoint] = None
    grant_types_supported: typing.Optional[ConnectionGrantTypesSupported] = None
    id_token_encryption_alg_values_supported: typing.Optional[ConnectionIdTokenEncryptionAlgValuesSupported] = None
    id_token_encryption_enc_values_supported: typing.Optional[ConnectionIdTokenEncryptionEncValuesSupported] = None
    id_token_signing_alg_values_supported: ConnectionIdTokenSigningAlgValuesSupported
    issuer: ConnectionIssuer
    jwks_uri: ConnectionJwksUri
    op_policy_uri: typing.Optional[ConnectionOpPolicyUri] = None
    op_tos_uri: typing.Optional[ConnectionOpTosUri] = None
    registration_endpoint: typing.Optional[ConnectionRegistrationEndpoint] = None
    request_object_encryption_alg_values_supported: typing.Optional[
        ConnectionRequestObjectEncryptionAlgValuesSupported
    ] = None
    request_object_encryption_enc_values_supported: typing.Optional[
        ConnectionRequestObjectEncryptionEncValuesSupported
    ] = None
    request_object_signing_alg_values_supported: typing.Optional[ConnectionRequestObjectSigningAlgValuesSupported] = (
        None
    )
    request_parameter_supported: typing.Optional[ConnectionRequestParameterSupported] = None
    request_uri_parameter_supported: typing.Optional[ConnectionRequestUriParameterSupported] = None
    require_request_uri_registration: typing.Optional[ConnectionRequireRequestUriRegistration] = None
    response_modes_supported: typing.Optional[ConnectionResponseModesSupported] = None
    response_types_supported: typing.Optional[ConnectionResponseTypesSupported] = None
    scopes_supported: typing.Optional[ConnectionScopesSupported] = None
    service_documentation: typing.Optional[ConnectionServiceDocumentation] = None
    subject_types_supported: typing.Optional[ConnectionSubjectTypesSupported] = None
    token_endpoint: typing.Optional[ConnectionTokenEndpoint] = None
    token_endpoint_auth_methods_supported: typing.Optional[ConnectionTokenEndpointAuthMethodsSupported] = None
    token_endpoint_auth_signing_alg_values_supported: typing.Optional[
        ConnectionTokenEndpointAuthSigningAlgValuesSupported
    ] = None
    ui_locales_supported: typing.Optional[ConnectionUiLocalesSupported] = None
    userinfo_encryption_alg_values_supported: typing.Optional[ConnectionUserinfoEncryptionAlgValuesSupported] = None
    userinfo_encryption_enc_values_supported: typing.Optional[ConnectionUserinfoEncryptionEncValuesSupported] = None
    userinfo_endpoint: typing.Optional[ConnectionUserinfoEndpoint] = None
    userinfo_signing_alg_values_supported: typing.Optional[ConnectionUserinfoSigningAlgValuesSupported] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
