# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection_passkey_challenge_ui_enum import ConnectionPasskeyChallengeUiEnum


class ConnectionPasskeyOptions(UniversalBaseModel):
    """
    Options for the passkey authentication method
    """

    challenge_ui: typing.Optional[ConnectionPasskeyChallengeUiEnum] = None
    progressive_enrollment_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables or disables progressive enrollment of passkeys for the connection.
    """

    local_enrollment_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables or disables enrollment prompt for local passkey when user authenticates using a cross-device passkey for the connection.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
