# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection_name_prefix_template import ConnectionNamePrefixTemplate
from .connection_profile_config import ConnectionProfileConfig
from .connection_profile_enabled_features import ConnectionProfileEnabledFeatures
from .connection_profile_name import ConnectionProfileName
from .connection_profile_organization import ConnectionProfileOrganization
from .connection_profile_strategy_overrides import ConnectionProfileStrategyOverrides


class ConnectionProfileTemplate(UniversalBaseModel):
    """
    The structure of the template, which can be used as the payload for creating or updating a Connection Profile.
    """

    name: typing.Optional[ConnectionProfileName] = None
    organization: typing.Optional[ConnectionProfileOrganization] = None
    connection_name_prefix_template: typing.Optional[ConnectionNamePrefixTemplate] = None
    enabled_features: typing.Optional[ConnectionProfileEnabledFeatures] = None
    connection_config: typing.Optional[ConnectionProfileConfig] = None
    strategy_overrides: typing.Optional[ConnectionProfileStrategyOverrides] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
