# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ConnectionScriptsOAuth2(UniversalBaseModel):
    """
    Custom scripts to transform user profile data or modify OAuth2 flow behavior
    """

    fetch_user_profile: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fetchUserProfile")] = (
        pydantic.Field(default=None)
    )
    """
    Custom JavaScript function to retrieve and transform user profile data from the identity provider. Called with the access token and token exchange response. Must return a user profile object. Executed in a sandboxed environment. If not provided, an empty profile object is used.
    """

    get_logout_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="getLogoutUrl")] = (
        pydantic.Field(default=None)
    )
    """
    Custom JavaScript function to dynamically construct the logout URL for the identity provider. Called with the request query parameters and must invoke a callback with the logout URL. Only used if 'logoutUrl' is not configured. Executed in a sandboxed environment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
