# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .phone_provider_channel_enum import PhoneProviderChannelEnum
from .phone_provider_configuration import PhoneProviderConfiguration
from .phone_provider_name_enum import PhoneProviderNameEnum


class CreateBrandingPhoneProviderResponseContent(UniversalBaseModel):
    """
    Phone provider configuration schema
    """

    id: typing.Optional[str] = None
    tenant: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the tenant
    """

    name: PhoneProviderNameEnum
    channel: typing.Optional[PhoneProviderChannelEnum] = None
    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the provider is enabled (false) or disabled (true).
    """

    configuration: typing.Optional[PhoneProviderConfiguration] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The provider's creation date and time in ISO 8601 format
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time of the last update to the provider in ISO 8601 format
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
