# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .email_provider_credentials import EmailProviderCredentials
from .email_provider_settings import EmailProviderSettings


class CreateEmailProviderResponseContent(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default="sendgrid")
    """
    Name of the email provider. Can be `mailgun`, `mandrill`, `sendgrid`, `ses`, `sparkpost`, `smtp`, `azure_cs`, `ms365`, or `custom`.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether the provider is enabled (true) or disabled (false).
    """

    default_from_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address to use as "from" when no other address specified.
    """

    credentials: typing.Optional[EmailProviderCredentials] = None
    settings: typing.Optional[EmailProviderSettings] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
