# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .encryption_key_state import EncryptionKeyState
from .encryption_key_type import EncryptionKeyType


class CreateEncryptionKeyResponseContent(UniversalBaseModel):
    """
    Encryption key
    """

    kid: str = pydantic.Field()
    """
    Key ID
    """

    type: EncryptionKeyType
    state: EncryptionKeyState
    created_at: dt.datetime = pydantic.Field()
    """
    Key creation timestamp
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Key update timestamp
    """

    parent_kid: str = pydantic.Field()
    """
    ID of parent wrapping key
    """

    public_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Public key in PEM format
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
