# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .event_stream_delivery_status_enum import EventStreamDeliveryStatusEnum
from .event_stream_event_type_enum import EventStreamEventTypeEnum


class CreateEventStreamRedeliveryResponseContent(UniversalBaseModel):
    date_from: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    An RFC-3339 date-time for redelivery start, inclusive. Does not allow sub-second precision.
    """

    date_to: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    An RFC-3339 date-time for redelivery end, exclusive. Does not allow sub-second precision.
    """

    statuses: typing.Optional[typing.List[EventStreamDeliveryStatusEnum]] = pydantic.Field(default=None)
    """
    Filter by status
    """

    event_types: typing.Optional[typing.List[EventStreamEventTypeEnum]] = pydantic.Field(default=None)
    """
    Filter by event type
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
