# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .event_stream_cloud_event import EventStreamCloudEvent
from .event_stream_delivery_attempt import EventStreamDeliveryAttempt
from .event_stream_delivery_event_type_enum import EventStreamDeliveryEventTypeEnum
from .event_stream_delivery_status_enum import EventStreamDeliveryStatusEnum


class CreateEventStreamTestEventResponseContent(UniversalBaseModel):
    """
    Metadata about a specific attempt to deliver an event
    """

    id: str = pydantic.Field()
    """
    Unique identifier for the delivery
    """

    event_stream_id: str = pydantic.Field()
    """
    Unique identifier for the event stream.
    """

    status: EventStreamDeliveryStatusEnum = "failed"
    event_type: EventStreamDeliveryEventTypeEnum
    attempts: typing.List[EventStreamDeliveryAttempt] = pydantic.Field()
    """
    Results of delivery attempts
    """

    event: typing.Optional[EventStreamCloudEvent] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
