# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .organization_discovery_domain_status import OrganizationDiscoveryDomainStatus


class CreateOrganizationDiscoveryDomainResponseContent(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Organization discovery domain identifier.
    """

    domain: str = pydantic.Field()
    """
    The domain name to associate with the organization e.g. acme.com.
    """

    status: OrganizationDiscoveryDomainStatus
    verification_txt: str = pydantic.Field()
    """
    A unique token generated for the discovery domain. This must be placed in a DNS TXT record at the location specified by the verification_host field to prove domain ownership.
    """

    verification_host: str = pydantic.Field()
    """
    The full domain where the TXT record should be added.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
