# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .organization_branding import OrganizationBranding
from .organization_enabled_connection import OrganizationEnabledConnection
from .organization_metadata import OrganizationMetadata
from .token_quota import TokenQuota


class CreateOrganizationResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization identifier.
    """

    name: typing.Optional[str] = pydantic.Field(default="organization-1")
    """
    The name of this organization.
    """

    display_name: typing.Optional[str] = pydantic.Field(default="Acme Users")
    """
    Friendly name of this organization.
    """

    branding: typing.Optional[OrganizationBranding] = None
    metadata: typing.Optional[OrganizationMetadata] = None
    token_quota: typing.Optional[TokenQuota] = None
    enabled_connections: typing.Optional[typing.List[OrganizationEnabledConnection]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
