# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .resource_server_consent_policy_enum import ResourceServerConsentPolicyEnum
from .resource_server_proof_of_possession import ResourceServerProofOfPossession
from .resource_server_scope import ResourceServerScope
from .resource_server_subject_type_authorization import ResourceServerSubjectTypeAuthorization
from .resource_server_token_dialect_response_enum import ResourceServerTokenDialectResponseEnum
from .resource_server_token_encryption import ResourceServerTokenEncryption
from .signing_algorithm_enum import SigningAlgorithmEnum


class CreateResourceServerResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the API (resource server).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Friendly name for this resource server. Can not contain `<` or `>` characters.
    """

    is_system: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this is an Auth0 system API (true) or a custom API (false).
    """

    identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the API used as the audience parameter on authorization calls. Can not be changed once set.
    """

    scopes: typing.Optional[typing.List[ResourceServerScope]] = pydantic.Field(default=None)
    """
    List of permissions (scopes) that this API uses.
    """

    signing_alg: typing.Optional[SigningAlgorithmEnum] = None
    signing_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Secret used to sign tokens when using symmetric algorithms (HS256).
    """

    allow_offline_access: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether refresh tokens can be issued for this API (true) or not (false).
    """

    skip_consent_for_verifiable_first_party_clients: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to skip user consent for applications flagged as first party (true) or not (false).
    """

    token_lifetime: typing.Optional[int] = pydantic.Field(default=None)
    """
    Expiration value (in seconds) for access tokens issued for this API from the token endpoint.
    """

    token_lifetime_for_web: typing.Optional[int] = pydantic.Field(default=None)
    """
    Expiration value (in seconds) for access tokens issued for this API via Implicit or Hybrid Flows. Cannot be greater than the `token_lifetime` value.
    """

    enforce_policies: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether authorization polices are enforced (true) or unenforced (false).
    """

    token_dialect: typing.Optional[ResourceServerTokenDialectResponseEnum] = None
    token_encryption: typing.Optional[ResourceServerTokenEncryption] = None
    consent_policy: typing.Optional[ResourceServerConsentPolicyEnum] = None
    authorization_details: typing.Optional[typing.List[typing.Any]] = None
    proof_of_possession: typing.Optional[ResourceServerProofOfPossession] = None
    subject_type_authorization: typing.Optional[ResourceServerSubjectTypeAuthorization] = None
    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The client ID of the client that this resource server is linked to
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
