# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .self_service_profile_allowed_strategy_enum import SelfServiceProfileAllowedStrategyEnum
from .self_service_profile_branding_properties import SelfServiceProfileBrandingProperties
from .self_service_profile_user_attribute import SelfServiceProfileUserAttribute


class CreateSelfServiceProfileResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default="ssp_n7SNCL8seoyV1TuSTCnAeo")
    """
    The unique ID of the self-service Profile.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the self-service Profile.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the self-service Profile.
    """

    user_attributes: typing.Optional[typing.List[SelfServiceProfileUserAttribute]] = pydantic.Field(default=None)
    """
    List of attributes to be mapped that will be shown to the user during the SS-SSO flow.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this self-service Profile was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this self-service Profile was updated.
    """

    branding: typing.Optional[SelfServiceProfileBrandingProperties] = None
    allowed_strategies: typing.Optional[typing.List[SelfServiceProfileAllowedStrategyEnum]] = pydantic.Field(
        default=None
    )
    """
    List of IdP strategies that will be shown to users during the Self-Service SSO flow. Possible values: [`oidc`, `samlp`, `waad`, `google-apps`, `adfs`, `okta`, `keycloak-samlp`, `pingfederate`]
    """

    user_attribute_profile_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user-attribute-profile to associate with this self-service profile.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
