# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .token_exchange_profile_type_enum import TokenExchangeProfileTypeEnum


class CreateTokenExchangeProfileResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique ID of the token exchange profile.
    """

    name: typing.Optional[str] = pydantic.Field(default="Token Exchange Profile 1")
    """
    Friendly name of this profile.
    """

    subject_token_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Subject token type for this profile. When receiving a token exchange request on the Authentication API, the corresponding token exchange profile with a matching subject_token_type will be executed. This must be a URI.
    """

    action_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the Custom Token Exchange action to execute for this profile, in order to validate the subject_token. The action must use the custom-token-exchange trigger.
    """

    type: typing.Optional[TokenExchangeProfileTypeEnum] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this profile was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this profile was updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
