# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .created_user_authentication_method_type_enum import CreatedUserAuthenticationMethodTypeEnum
from .preferred_authentication_method_enum import PreferredAuthenticationMethodEnum
from .user_authentication_method_properties import UserAuthenticationMethodProperties


class CreateUserAuthenticationMethodResponseContent(UniversalBaseModel):
    """
    The successfully created authentication method.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the newly created authentication method (automatically generated by the application)
    """

    type: CreatedUserAuthenticationMethodTypeEnum
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable label to identify the authentication method.
    """

    totp_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base32 encoded secret for TOTP generation
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to phone authentication methods only. The destination phone number used to send verification codes via text and voice.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to email authentication methods only. The email address used to send verification messages.
    """

    authentication_methods: typing.Optional[typing.List[UserAuthenticationMethodProperties]] = None
    preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = None
    key_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn authenticators only. The id of the credential.
    """

    public_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn authenticators only. The public key.
    """

    aaguid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to passkeys only. Authenticator Attestation Globally Unique Identifier.
    """

    relying_party_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn authenticators only. The relying party identifier.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Authentication method creation date
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
