# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .user_app_metadata_schema import UserAppMetadataSchema
from .user_date_schema import UserDateSchema
from .user_identity_schema import UserIdentitySchema
from .user_metadata_schema import UserMetadataSchema


class CreateUserResponseContent(UniversalBaseModel):
    user_id: typing.Optional[str] = pydantic.Field(default="auth0|507f1f77bcf86cd799439020")
    """
    ID of the user which can be used when interacting with other APIs.
    """

    email: typing.Optional[str] = pydantic.Field(default="john.doe@gmail.com")
    """
    Email address of this user.
    """

    email_verified: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether this email address is verified (true) or unverified (false).
    """

    username: typing.Optional[str] = pydantic.Field(default="johndoe")
    """
    Username of this user.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default="+199999999999999")
    """
    Phone number for this user. Follows the <a href="https://en.wikipedia.org/wiki/E.164">E.164 recommendation</a>.
    """

    phone_verified: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether this phone number has been verified (true) or not (false).
    """

    created_at: typing.Optional[UserDateSchema] = None
    updated_at: typing.Optional[UserDateSchema] = None
    identities: typing.Optional[typing.List[UserIdentitySchema]] = pydantic.Field(default=None)
    """
    Array of user identity objects when accounts are linked.
    """

    app_metadata: typing.Optional[UserAppMetadataSchema] = None
    user_metadata: typing.Optional[UserMetadataSchema] = None
    picture: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to picture, photo, or avatar of this user.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of this user.
    """

    nickname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Preferred nickname or alias of this user.
    """

    multifactor: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of multi-factor authentication providers with which this user has enrolled.
    """

    last_ip: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last IP address from which this user logged in.
    """

    last_login: typing.Optional[UserDateSchema] = None
    logins_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of logins this user has performed.
    """

    blocked: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this user was blocked by an administrator (true) or is not (false).
    """

    given_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Given name/first name/forename of this user.
    """

    family_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Family name/last name/surname of this user.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
