# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .custom_signing_key_algorithm_enum import CustomSigningKeyAlgorithmEnum
from .custom_signing_key_curve_enum import CustomSigningKeyCurveEnum
from .custom_signing_key_operation_enum import CustomSigningKeyOperationEnum
from .custom_signing_key_type_enum import CustomSigningKeyTypeEnum
from .custom_signing_key_use_enum import CustomSigningKeyUseEnum


class CustomSigningKeyJwk(UniversalBaseModel):
    """
    JWK representing a custom public signing key.
    """

    kty: CustomSigningKeyTypeEnum
    kid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key identifier
    """

    use: typing.Optional[CustomSigningKeyUseEnum] = None
    key_ops: typing.Optional[typing.List[CustomSigningKeyOperationEnum]] = pydantic.Field(default=None)
    """
    Key operations
    """

    alg: typing.Optional[CustomSigningKeyAlgorithmEnum] = None
    n: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key modulus
    """

    e: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key exponent
    """

    crv: typing.Optional[CustomSigningKeyCurveEnum] = None
    x: typing.Optional[str] = pydantic.Field(default=None)
    """
    X coordinate
    """

    y: typing.Optional[str] = pydantic.Field(default=None)
    """
    Y coordinate
    """

    x_5_u: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="x5u")] = pydantic.Field(default=None)
    """
    X.509 URL
    """

    x_5_c: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="x5c")] = pydantic.Field(
        default=None
    )
    """
    X.509 certificate chain
    """

    x_5_t: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="x5t")] = pydantic.Field(default=None)
    """
    X.509 certificate SHA-1 thumbprint
    """

    x_5_t_s_256: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="x5t#S256")] = pydantic.Field(
        default=None
    )
    """
    X.509 certificate SHA-256 thumbprint
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
