# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DailyStats(UniversalBaseModel):
    date: typing.Optional[str] = pydantic.Field(default="2014-01-01T00:00:00.000Z")
    """
    Date these events occurred in ISO 8601 format.
    """

    logins: typing.Optional[int] = pydantic.Field(default=100)
    """
    Number of logins on this date.
    """

    signups: typing.Optional[int] = pydantic.Field(default=100)
    """
    Number of signups on this date.
    """

    leaked_passwords: typing.Optional[int] = pydantic.Field(default=100)
    """
    Number of breached-password detections on this date (subscription required).
    """

    updated_at: typing.Optional[str] = pydantic.Field(default="2014-01-01T02:00:00.000Z")
    """
    Date and time this stats entry was last updated in ISO 8601 format.
    """

    created_at: typing.Optional[str] = pydantic.Field(default="2014-01-01T20:00:00.000Z")
    """
    Approximate date and time the first event occurred in ISO 8601 format.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
