# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .user_profile_data import UserProfileData


class DeleteUserIdentityResponseContentItem(UniversalBaseModel):
    connection: str = pydantic.Field(default="Initial-Connection")
    """
    The name of the connection for the identity.
    """

    user_id: str = pydantic.Field(default="5457edea1b8f22891a000004")
    """
    The unique identifier for the user for the identity.
    """

    provider: str = pydantic.Field(default="auth0")
    """
    The type of identity provider.
    """

    is_social: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isSocial")] = pydantic.Field(
        default=None
    )
    """
    <code>true</code> if the identity provider is a social provider, <code>false</code>s otherwise
    """

    access_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token returned only if scope read:user_idp_tokens is defined
    """

    access_token_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP access token secret returned only if scope read:user_idp_tokens is defined.
    """

    refresh_token: typing.Optional[str] = pydantic.Field(default=None)
    """
    IDP refresh token returned only if scope read:user_idp_tokens is defined.
    """

    profile_data: typing_extensions.Annotated[typing.Optional[UserProfileData], FieldMetadata(alias="profileData")] = (
        None
    )

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
