# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .domain_certificate_authority_enum import DomainCertificateAuthorityEnum
from .domain_certificate_status_enum import DomainCertificateStatusEnum


class DomainCertificate(UniversalBaseModel):
    """
    Certificate information. This object is relevant only for Custom Domains with Auth0-Managed Certificates.
    """

    status: typing.Optional[DomainCertificateStatusEnum] = None
    error_msg: typing.Optional[str] = pydantic.Field(default=None)
    """
    A user-friendly error message will be presented if the certificate status is provisioning_failed or renewing_failed.
    """

    certificate_authority: typing.Optional[DomainCertificateAuthorityEnum] = None
    renews_before: typing.Optional[str] = pydantic.Field(default=None)
    """
    The certificate will be renewed prior to this date.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
