# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .domain_verification_method import DomainVerificationMethod
from .domain_verification_status_enum import DomainVerificationStatusEnum


class DomainVerification(UniversalBaseModel):
    """
    Domain verification settings.
    """

    methods: typing.Optional[typing.List[DomainVerificationMethod]] = pydantic.Field(default=None)
    """
    Domain verification methods.
    """

    status: typing.Optional[DomainVerificationStatusEnum] = None
    error_msg: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user0-friendly error message in case of failed verification. This field is relevant only for Custom Domains with Auth0-Managed Certificates.
    """

    last_verified_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The date and time when the custom domain was last verified. This field is relevant only for Custom Domains with Auth0-Managed Certificates.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
