# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class EventStreamCloudEvent(UniversalBaseModel):
    """
    Event content. This will only be set if delivery failed.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the event
    """

    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    Where the event originated
    """

    specversion: typing.Optional[str] = pydantic.Field(default=None)
    """
    Version of CloudEvents spec
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of the event (e.g., user.created)
    """

    time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp at which the event was generated
    """

    data: typing.Optional[str] = pydantic.Field(default=None)
    """
    Event contents encoded as a string.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
