# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .event_stream_status_enum import EventStreamStatusEnum
from .event_stream_subscription import EventStreamSubscription
from .event_stream_webhook_destination import EventStreamWebhookDestination


class EventStreamWebhookResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the event stream.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the event stream.
    """

    subscriptions: typing.Optional[typing.List[EventStreamSubscription]] = pydantic.Field(default=None)
    """
    List of event types subscribed to in this stream.
    """

    destination: typing.Optional[EventStreamWebhookDestination] = None
    status: typing.Optional[EventStreamStatusEnum] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the event stream was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the event stream was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
