# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .linked_client_configuration import LinkedClientConfiguration


class ExpressConfigurationOrNull(UniversalBaseModel):
    """
    Application specific configuration for use with the OIN Express Configuration feature.
    """

    initiate_login_uri_template: str = pydantic.Field()
    """
    The URI users should bookmark to log in to this application. Variable substitution is permitted for the following properties: organization_name, organization_id, and connection_name.
    """

    user_attribute_profile_id: str = pydantic.Field()
    """
    The ID of the user attribute profile to use for this application.
    """

    connection_profile_id: str = pydantic.Field()
    """
    The ID of the connection profile to use for this application.
    """

    enable_client: bool = pydantic.Field()
    """
    When true, all connections made via express configuration will be enabled for this application.
    """

    enable_organization: bool = pydantic.Field()
    """
    When true, all connections made via express configuration will have the associated organization enabled.
    """

    linked_clients: typing.Optional[typing.List[LinkedClientConfiguration]] = pydantic.Field(default=None)
    """
    List of client IDs that are linked to this express configuration (e.g. web or mobile clients).
    """

    okta_oin_client_id: str = pydantic.Field()
    """
    This is the unique identifier for the Okta OIN Express Configuration Client, which Okta will use for this application.
    """

    admin_login_domain: str = pydantic.Field()
    """
    This is the domain that admins are expected to log in via for authenticating for express configuration. It can be either the canonical domain or a registered custom domain.
    """

    oin_submission_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier of the published application in the OKTA OIN.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
