# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .action_base import ActionBase
from .action_error import ActionError
from .action_secret_response import ActionSecretResponse
from .action_trigger import ActionTrigger
from .action_version_build_status_enum import ActionVersionBuildStatusEnum
from .action_version_dependency import ActionVersionDependency


class GetActionVersionResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default="12a3b9e6-06e6-4a29-96bf-90c82fe79a0d")
    """
    The unique id of an action version.
    """

    action_id: typing.Optional[str] = pydantic.Field(default="910b1053-577f-4d81-a8c8-020e7319a38a")
    """
    The id of the action to which this version belongs.
    """

    code: typing.Optional[str] = pydantic.Field(default="module.exports = () => {}")
    """
    The source code of this specific version of the action.
    """

    dependencies: typing.Optional[typing.List[ActionVersionDependency]] = pydantic.Field(default=None)
    """
    The list of third party npm modules, and their versions, that this specific version depends on. 
    """

    deployed: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Indicates if this specific version is the currently one deployed.
    """

    runtime: typing.Optional[str] = pydantic.Field(default="node22")
    """
    The Node runtime. For example: `node22`
    """

    secrets: typing.Optional[typing.List[ActionSecretResponse]] = pydantic.Field(default=None)
    """
    The list of secrets that are included in an action or a version of an action.
    """

    status: typing.Optional[ActionVersionBuildStatusEnum] = None
    number: typing.Optional[float] = pydantic.Field(default=1.0)
    """
    The index of this version in list of versions for the action.
    """

    errors: typing.Optional[typing.List[ActionError]] = pydantic.Field(default=None)
    """
    Any errors that occurred while the version was being built.
    """

    action: typing.Optional[ActionBase] = None
    built_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this version was built successfully.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when this version was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when a version was updated. Versions are never updated externally. Only Auth0 will update an action version as it is being built.
    """

    supported_triggers: typing.Optional[typing.List[ActionTrigger]] = pydantic.Field(default=None)
    """
    The list of triggers that this version supports. At this time, a version can only target a single trigger at a time.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
