# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .breached_password_detection_admin_notification_frequency_enum import (
    BreachedPasswordDetectionAdminNotificationFrequencyEnum,
)
from .breached_password_detection_method_enum import BreachedPasswordDetectionMethodEnum
from .breached_password_detection_shields_enum import BreachedPasswordDetectionShieldsEnum
from .breached_password_detection_stage import BreachedPasswordDetectionStage


class GetBreachedPasswordDetectionSettingsResponseContent(UniversalBaseModel):
    enabled: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether or not breached password detection is active.
    """

    shields: typing.Optional[typing.List[BreachedPasswordDetectionShieldsEnum]] = pydantic.Field(default=None)
    """
    Action to take when a breached password is detected during a login.
          Possible values: <code>block</code>, <code>user_notification</code>, <code>admin_notification</code>.
    """

    admin_notification_frequency: typing.Optional[
        typing.List[BreachedPasswordDetectionAdminNotificationFrequencyEnum]
    ] = pydantic.Field(default=None)
    """
    When "admin_notification" is enabled, determines how often email notifications are sent.
            Possible values: <code>immediately</code>, <code>daily</code>, <code>weekly</code>, <code>monthly</code>.
    """

    method: typing.Optional[BreachedPasswordDetectionMethodEnum] = None
    stage: typing.Optional[BreachedPasswordDetectionStage] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
