# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .client_credential_algorithm_enum import ClientCredentialAlgorithmEnum
from .client_credential_type_enum import ClientCredentialTypeEnum


class GetClientCredentialResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default="cred_1m7sfABoNTTKYwTQ8qt6tX")
    """
    ID of the credential. Generated on creation.
    """

    name: typing.Optional[str] = pydantic.Field(default="")
    """
    The name given to the credential by the user.
    """

    kid: typing.Optional[str] = pydantic.Field(default="IZSSTECp...")
    """
    The key identifier of the credential, generated on creation.
    """

    alg: typing.Optional[ClientCredentialAlgorithmEnum] = None
    credential_type: typing.Optional[ClientCredentialTypeEnum] = None
    subject_dn: typing.Optional[str] = pydantic.Field(default=None)
    """
    The X509 certificate's Subject Distinguished Name
    """

    thumbprint_sha_256: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="thumbprint_sha256")] = (
        pydantic.Field(default=None)
    )
    """
    The X509 certificate's SHA256 thumbprint
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date the credential was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date the credential was updated.
    """

    expires_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date representing the expiration of the credential.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
