# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .connection_authentication_purpose import ConnectionAuthenticationPurpose
from .connection_connected_accounts_purpose import ConnectionConnectedAccountsPurpose
from .connection_options import ConnectionOptions
from .connections_metadata import ConnectionsMetadata


class GetConnectionResponseContent(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default="My connection")
    """
    The name of the connection
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Connection name used in login screen
    """

    options: typing.Optional[ConnectionOptions] = None
    id: typing.Optional[str] = pydantic.Field(default="con_0000000000000001")
    """
    The connection's identifier
    """

    strategy: typing.Optional[str] = pydantic.Field(default="auth0")
    """
    The type of the connection, related to the identity provider
    """

    realms: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Defines the realms for which the connection will be used (ie: email domains). If the array is empty or the property is not specified, the connection name will be added as realm.
    """

    enabled_clients: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    DEPRECATED property. Use the GET /connections/:id/clients endpoint to get the ids of the clients for which the connection is enabled
    """

    is_domain_connection: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the connection is domain level
    """

    show_as_button: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD.
    """

    metadata: typing.Optional[ConnectionsMetadata] = None
    authentication: typing.Optional[ConnectionAuthenticationPurpose] = None
    connected_accounts: typing.Optional[ConnectionConnectedAccountsPurpose] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
