# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .directory_provisioning_mapping_item import DirectoryProvisioningMappingItem


class GetDirectoryProvisioningResponseContent(UniversalBaseModel):
    connection_id: str = pydantic.Field()
    """
    The connection's identifier
    """

    connection_name: str = pydantic.Field()
    """
    The connection's name
    """

    strategy: str = pydantic.Field()
    """
    The connection's strategy
    """

    mapping: typing.List[DirectoryProvisioningMappingItem] = pydantic.Field()
    """
    The mapping between Auth0 and IDP user attributes
    """

    synchronize_automatically: bool = pydantic.Field()
    """
    Whether periodic automatic synchronization is enabled
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The timestamp at which the directory provisioning configuration was created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    The timestamp at which the directory provisioning configuration was last updated
    """

    last_synchronization_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp at which the connection was last synchronized
    """

    last_synchronization_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The status of the last synchronization
    """

    last_synchronization_error: typing.Optional[str] = pydantic.Field(default=None)
    """
    The error message of the last synchronization, if any
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
