# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .email_template_name_enum import EmailTemplateNameEnum


class GetEmailTemplateResponseContent(UniversalBaseModel):
    template: typing.Optional[EmailTemplateNameEnum] = None
    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    Body of the email template.
    """

    from_: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="from")] = pydantic.Field(
        default="sender@auth0.com"
    )
    """
    Senders `from` email address.
    """

    result_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="resultUrl")] = pydantic.Field(
        default=None
    )
    """
    URL to redirect the user to after a successful action.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    Subject line of the email.
    """

    syntax: typing.Optional[str] = pydantic.Field(default="liquid")
    """
    Syntax of the template body.
    """

    url_lifetime_in_seconds: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="urlLifetimeInSeconds")
    ] = pydantic.Field(default=None)
    """
    Lifetime in seconds that the link within the email will be valid for.
    """

    include_email_in_redirect: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="includeEmailInRedirect")
    ] = pydantic.Field(default=None)
    """
    Whether the `reset_email` and `verify_email` templates should include the user's email address as the `email` parameter in the returnUrl (true) or whether no email address should be included in the redirect (false). Defaults to true.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the template is enabled (true) or disabled (false).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
