# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .flow_execution_debug import FlowExecutionDebug


class GetFlowExecutionResponseContent(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Flow execution identifier
    """

    trace_id: str = pydantic.Field()
    """
    Trace id
    """

    journey_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Journey id
    """

    status: str = pydantic.Field()
    """
    Execution status
    """

    debug: typing.Optional[FlowExecutionDebug] = None
    created_at: dt.datetime = pydantic.Field()
    """
    The ISO 8601 formatted date when this flow execution was created.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    The ISO 8601 formatted date when this flow execution was updated.
    """

    started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date when this flow execution started.
    """

    ended_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date when this flow execution ended.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
