# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GetFlowsVaultConnectionResponseContent(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Flows Vault Connection identifier.
    """

    app_id: str = pydantic.Field()
    """
    Flows Vault Connection app identifier.
    """

    environment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Flows Vault Connection environment.
    """

    name: str = pydantic.Field()
    """
    Flows Vault Connection name.
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Flows Vault Connection custom account name.
    """

    ready: bool = pydantic.Field()
    """
    Whether the Flows Vault Connection is configured.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The ISO 8601 formatted date when this Flows Vault Connection was created.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    The ISO 8601 formatted date when this Flows Vault Connection was updated.
    """

    refreshed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The ISO 8601 formatted date when this Flows Vault Connection was refreshed.
    """

    fingerprint: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
