# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .job_file_format_enum import JobFileFormatEnum


class GetJobResponseContent(UniversalBaseModel):
    status: str = pydantic.Field(default="pending")
    """
    Status of this job.
    """

    type: str = pydantic.Field(default="users_import")
    """
    Type of job this is.
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    When this job was created.
    """

    id: str = pydantic.Field(default="job_0000000000000001")
    """
    ID of this job.
    """

    connection_id: typing.Optional[str] = pydantic.Field(default="con_0000000000000001")
    """
    connection_id of the connection this job uses.
    """

    location: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to download the result of this job.
    """

    percentage_done: typing.Optional[int] = pydantic.Field(default=None)
    """
    Completion percentage of this job.
    """

    time_left_seconds: typing.Optional[int] = pydantic.Field(default=None)
    """
    Estimated time remaining before job completes.
    """

    format: typing.Optional[JobFileFormatEnum] = None
    status_details: typing.Optional[str] = pydantic.Field(default=None)
    """
    Status details.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
