# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .log_date import LogDate
from .log_details import LogDetails
from .log_location_info import LogLocationInfo
from .log_security_context import LogSecurityContext


class GetLogResponseContent(UniversalBaseModel):
    date: typing.Optional[LogDate] = None
    type: typing.Optional[str] = pydantic.Field(default="sapi")
    """
    Type of event.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of this event.
    """

    connection: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the connection the event relates to.
    """

    connection_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the connection the event relates to.
    """

    client_id: typing.Optional[str] = pydantic.Field(default="AaiyAPdpYdesoKnqjj8HJqRn4T5titww")
    """
    ID of the client (application).
    """

    client_name: typing.Optional[str] = pydantic.Field(default="My application Name")
    """
    Name of the client (application).
    """

    ip: typing.Optional[str] = pydantic.Field(default="190.257.209.19")
    """
    IP address of the log event source.
    """

    hostname: typing.Optional[str] = pydantic.Field(default="190.257.209.19")
    """
    Hostname the event applies to.
    """

    user_id: typing.Optional[str] = pydantic.Field(default="auth0|56c75c4e42b6359e98374bc2")
    """
    ID of the user involved in the event.
    """

    user_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the user involved in the event.
    """

    audience: typing.Optional[str] = pydantic.Field(default=None)
    """
    API audience the event applies to.
    """

    scope: typing.Optional[str] = pydantic.Field(default="")
    """
    Scope permissions applied to the event.
    """

    strategy: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the strategy involved in the event.
    """

    strategy_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Type of strategy involved in the event.
    """

    log_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID of the event.
    """

    is_mobile: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isMobile")] = pydantic.Field(
        default=None
    )
    """
    Whether the client was a mobile device (true) or desktop/laptop/server (false).
    """

    details: typing.Optional[LogDetails] = None
    user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    User agent string from the client device that caused the event.
    """

    security_context: typing.Optional[LogSecurityContext] = None
    location_info: typing.Optional[LogLocationInfo] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
