# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .refresh_token_date import RefreshTokenDate
from .refresh_token_device import RefreshTokenDevice
from .refresh_token_resource_server import RefreshTokenResourceServer
from .refresh_token_session_id import RefreshTokenSessionId


class GetRefreshTokenResponseContent(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the refresh token
    """

    user_id: typing.Optional[str] = pydantic.Field(default="auth0|507f1f77bcf86cd799439020")
    """
    ID of the user which can be used when interacting with other APIs.
    """

    created_at: typing.Optional[RefreshTokenDate] = None
    idle_expires_at: typing.Optional[RefreshTokenDate] = None
    expires_at: typing.Optional[RefreshTokenDate] = None
    device: typing.Optional[RefreshTokenDevice] = None
    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the client application granted with this refresh token
    """

    session_id: typing.Optional[RefreshTokenSessionId] = None
    rotating: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the token is a rotating refresh token
    """

    resource_servers: typing.Optional[typing.List[RefreshTokenResourceServer]] = pydantic.Field(default=None)
    """
    A list of the resource server IDs associated to this refresh-token and their granted scopes
    """

    last_exchanged_at: typing.Optional[RefreshTokenDate] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
