# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .signing_keys_date import SigningKeysDate


class GetSigningKeysResponseContent(UniversalBaseModel):
    kid: str = pydantic.Field(default="21hi274Rp02112mgkUGma")
    """
    The key id of the signing key
    """

    cert: str = pydantic.Field(
        default="-----BEGIN CERTIFICATE-----\r\nMIIDDTCCA...YiA0TQhAt8=\r\n-----END CERTIFICATE-----"
    )
    """
    The public certificate of the signing key
    """

    pkcs_7: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="pkcs7")] = pydantic.Field(
        default="-----BEGIN PKCS7-----\r\nMIIDPA....t8xAA==\r\n-----END PKCS7-----"
    )
    """
    The public certificate of the signing key in pkcs7 format
    """

    current: typing.Optional[bool] = pydantic.Field(default=True)
    """
    True if the key is the the current key
    """

    next: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the key is the the next key
    """

    previous: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the key is the the previous key
    """

    current_since: typing.Optional[SigningKeysDate] = None
    current_until: typing.Optional[SigningKeysDate] = None
    fingerprint: str = pydantic.Field(default="CC:FB:DD:D8:9A:B5:DE:1B:F0:CC:36:D2:99:59:21:12:03:DD:A8:25")
    """
    The cert fingerprint
    """

    thumbprint: str = pydantic.Field(default="CCFBDDD89AB5DE1BF0CC36D29959211203DDA825")
    """
    The cert thumbprint
    """

    revoked: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the key is revoked
    """

    revoked_at: typing.Optional[SigningKeysDate] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
