# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .default_token_quota import DefaultTokenQuota
from .session_cookie_schema import SessionCookieSchema
from .supported_locales import SupportedLocales
from .tenant_oidc_logout_settings import TenantOidcLogoutSettings
from .tenant_settings_device_flow import TenantSettingsDeviceFlow
from .tenant_settings_error_page import TenantSettingsErrorPage
from .tenant_settings_flags import TenantSettingsFlags
from .tenant_settings_guardian_page import TenantSettingsGuardianPage
from .tenant_settings_mtls import TenantSettingsMtls
from .tenant_settings_password_page import TenantSettingsPasswordPage
from .tenant_settings_resource_parameter_profile import TenantSettingsResourceParameterProfile
from .tenant_settings_sessions import TenantSettingsSessions


class GetTenantSettingsResponseContent(UniversalBaseModel):
    change_password: typing.Optional[TenantSettingsPasswordPage] = None
    guardian_mfa_page: typing.Optional[TenantSettingsGuardianPage] = None
    default_audience: typing.Optional[str] = pydantic.Field(default="")
    """
    Default audience for API authorization.
    """

    default_directory: typing.Optional[str] = pydantic.Field(default="")
    """
    Name of connection used for password grants at the `/token`endpoint. The following connection types are supported: LDAP, AD, Database Connections, Passwordless, Windows Azure Active Directory, ADFS.
    """

    error_page: typing.Optional[TenantSettingsErrorPage] = None
    device_flow: typing.Optional[TenantSettingsDeviceFlow] = None
    default_token_quota: typing.Optional[DefaultTokenQuota] = None
    flags: typing.Optional[TenantSettingsFlags] = None
    friendly_name: typing.Optional[str] = pydantic.Field(default="My Company")
    """
    Friendly name for this tenant.
    """

    picture_url: typing.Optional[str] = pydantic.Field(default="https://mycompany.org/logo.png")
    """
    URL of logo to be shown for this tenant (recommended size: 150x150)
    """

    support_email: typing.Optional[str] = pydantic.Field(default="support@mycompany.org")
    """
    End-user support email address.
    """

    support_url: typing.Optional[str] = pydantic.Field(default="https://mycompany.org/support")
    """
    End-user support URL.
    """

    allowed_logout_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    URLs that are valid to redirect to after logout from Auth0.
    """

    session_lifetime: typing.Optional[float] = pydantic.Field(default=168.0)
    """
    Number of hours a session will stay valid.
    """

    idle_session_lifetime: typing.Optional[float] = pydantic.Field(default=72.0)
    """
    Number of hours for which a session can be inactive before the user must log in again.
    """

    ephemeral_session_lifetime: typing.Optional[float] = pydantic.Field(default=72.0)
    """
    Number of hours an ephemeral (non-persistent) session will stay valid.
    """

    idle_ephemeral_session_lifetime: typing.Optional[float] = pydantic.Field(default=24.0)
    """
    Number of hours for which an ephemeral (non-persistent) session can be inactive before the user must log in again.
    """

    sandbox_version: typing.Optional[str] = pydantic.Field(default="22")
    """
    Selected sandbox version for the extensibility environment.
    """

    legacy_sandbox_version: typing.Optional[str] = pydantic.Field(default="")
    """
    Selected sandbox version for rules and hooks extensibility.
    """

    sandbox_versions_available: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Available sandbox versions for the extensibility environment.
    """

    default_redirection_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default absolute redirection uri, must be https
    """

    enabled_locales: typing.Optional[typing.List[SupportedLocales]] = pydantic.Field(default=None)
    """
    Supported locales for the user interface.
    """

    session_cookie: typing.Optional[SessionCookieSchema] = None
    sessions: typing.Optional[TenantSettingsSessions] = None
    oidc_logout: typing.Optional[TenantOidcLogoutSettings] = None
    allow_organization_name_in_authentication_api: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether to accept an organization name instead of an ID on auth endpoints
    """

    customize_mfa_in_postlogin_action: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether to enable flexible factors for MFA in the PostLogin action
    """

    acr_values_supported: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Supported ACR values
    """

    mtls: typing.Optional[TenantSettingsMtls] = None
    pushed_authorization_requests_supported: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Enables the use of Pushed Authorization Requests
    """

    authorization_response_iss_parameter_supported: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Supports iss parameter in authorization responses
    """

    skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
    If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
    See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.
    """

    resource_parameter_profile: typing.Optional[TenantSettingsResourceParameterProfile] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
