# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_method_type_enum import AuthenticationMethodTypeEnum
from .preferred_authentication_method_enum import PreferredAuthenticationMethodEnum
from .user_authentication_method_properties import UserAuthenticationMethodProperties


class GetUserAuthenticationMethodResponseContent(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the authentication method (auto generated)
    """

    type: AuthenticationMethodTypeEnum
    confirmed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The authentication method status
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human-readable label to identify the authentication method
    """

    authentication_methods: typing.Optional[typing.List[UserAuthenticationMethodProperties]] = None
    preferred_authentication_method: typing.Optional[PreferredAuthenticationMethodEnum] = None
    link_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of a linked authentication method. Linked authentication methods will be deleted together.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to phone authentication methods only. The destination phone number used to send verification codes via text and voice.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to email and email-verification authentication methods only. The email address used to send verification messages.
    """

    key_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn authentication methods only. The ID of the generated credential.
    """

    public_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn authentication methods only. The public key.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Authenticator creation date
    """

    enrolled_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Enrollment date
    """

    last_auth_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Last authentication
    """

    credential_device_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to passkeys only. The kind of device the credential is stored on as defined by backup eligibility. "single_device" credentials cannot be backed up and synced to another device, "multi_device" credentials can be backed up if enabled by the end-user.
    """

    credential_backed_up: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Applies to passkeys only. Whether the credential was backed up.
    """

    identity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to passkeys only. The ID of the user identity linked with the authentication method.
    """

    user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to passkeys only. The user-agent of the browser used to create the passkey.
    """

    aaguid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to passkey authentication methods only. Authenticator Attestation Globally Unique Identifier.
    """

    relying_party_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    Applies to webauthn/passkey authentication methods only. The credential's relying party identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
