# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Group(UniversalBaseModel):
    """
    Represents the metadata of a group. Member lists are retrieved via a separate endpoint.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the group (service-generated).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the group. Must be unique within its scope (connection, organization, or tenant). Must contain between 1 and 128 printable ASCII characters.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    External identifier for the group, often used for SCIM synchronization. Max length of 256 characters.
    """

    connection_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for the connection this group belongs to (if a connection group).
    """

    organization_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for the organization this group belongs to (if an organization group).
    """

    tenant_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Identifier for the tenant this group belongs to.
    """

    description: typing.Optional[str] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp of when the group was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp of when the group was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
