# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .integration_feature_type_enum import IntegrationFeatureTypeEnum
from .integration_release import IntegrationRelease


class Integration(UniversalBaseModel):
    """
    Integration defines a self contained functioning unit which partners
    publish. A partner may create one or many of these integrations.
    """

    id: typing.Optional[str] = pydantic.Field(default="8e9fe2d0-a2fc-4c8c-9e35-dae5afadb70b")
    """
    id is a system generated GUID. This same ID is designed to be federated in
    all the applicable localities.
    """

    catalog_id: typing.Optional[str] = pydantic.Field(default="awesome-auth0-integration")
    """
    catalog_id refers to the ID in the marketplace catalog
    """

    url_slug: typing.Optional[str] = pydantic.Field(default="awesome-auth0-integration-slug")
    """
    url_slug refers to the url_slug in the marketplace catalog
    """

    partner_id: typing.Optional[str] = pydantic.Field(default="b8575c12-8d9d-4b5c-b28e-671fe9d39029")
    """
    partner_id is the foreign key reference to the partner account this
    integration belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default="Example Auth0 integration")
    """
    name is the integration name, which will be used for display purposes in
    the marketplace.
    
    To start we're going to make sure the display name is at least 3
    characters. Can adjust this easily later.
    """

    description: typing.Optional[str] = pydantic.Field(default="An awesome Auth0 integration")
    """
    description adds more text for the integration name -- also relevant for
    the marketplace listing.
    """

    short_description: typing.Optional[str] = pydantic.Field(default="Awesome Auth0 integration")
    """
    short_description is the brief description of the integration, which is used for display purposes in cards
    """

    logo: typing.Optional[str] = None
    feature_type: typing.Optional[IntegrationFeatureTypeEnum] = None
    terms_of_use_url: typing.Optional[str] = None
    privacy_policy_url: typing.Optional[str] = None
    public_support_link: typing.Optional[str] = None
    current_release: typing.Optional[IntegrationRelease] = None
    created_at: typing.Optional[dt.datetime] = None
    updated_at: typing.Optional[dt.datetime] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
