# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .integration_required_param_option import IntegrationRequiredParamOption
from .integration_required_param_type_enum import IntegrationRequiredParamTypeEnum


class IntegrationRequiredParam(UniversalBaseModel):
    """
    Param are form input values, primarily utilized when specifying secrets and
    configuration values for actions.

    These are especially important for partner integrations -- but can be
    exposed to tenant admins as well if they want to parameterize their custom
    actions.
    """

    type: typing.Optional[IntegrationRequiredParamTypeEnum] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the parameter.
    """

    required: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The flag for if this parameter is required.
    """

    optional: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The temp flag for if this parameter is required (experimental; for Labs use only).
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The short label for this parameter.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lengthier description for this parameter.
    """

    default_value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default value for this parameter.
    """

    placeholder: typing.Optional[str] = pydantic.Field(default=None)
    """
    Placeholder text for this parameter.
    """

    options: typing.Optional[typing.List[IntegrationRequiredParamOption]] = pydantic.Field(default=None)
    """
    The allowable options for this param.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
