# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class LogLocationInfo(UniversalBaseModel):
    """
    Information about the location that triggered this event based on the `ip`.
    """

    country_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Two-letter <a href="https://www.iso.org/iso-3166-country-codes.html">Alpha-2 ISO 3166-1</a> country code.
    """

    country_code_3: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="country_code3")] = (
        pydantic.Field(default=None)
    )
    """
    Three-letter <a href="https://www.iso.org/iso-3166-country-codes.html">Alpha-3 ISO 3166-1</a> country code.
    """

    country_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full country name in English.
    """

    city_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Full city name in English.
    """

    latitude: typing.Optional[str] = pydantic.Field(default=None)
    """
    Global latitude (horizontal) position.
    """

    longitude: typing.Optional[str] = pydantic.Field(default=None)
    """
    Global longitude (vertical) position.
    """

    time_zone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Time zone name as found in the <a href="https://www.iana.org/time-zones">tz database</a>.
    """

    continent_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Continent the country is located within. Can be `AF` (Africa), `AN` (Antarctica), `AS` (Asia), `EU` (Europe), `NA` (North America), `OC` (Oceania) or `SA` (South America).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
