# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .log_stream_event_bridge_enum import LogStreamEventBridgeEnum
from .log_stream_event_bridge_sink import LogStreamEventBridgeSink
from .log_stream_filter import LogStreamFilter
from .log_stream_pii_config import LogStreamPiiConfig
from .log_stream_status_enum import LogStreamStatusEnum


class LogStreamEventBridgeResponseSchema(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the log stream
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    log stream name
    """

    status: typing.Optional[LogStreamStatusEnum] = None
    type: typing.Optional[LogStreamEventBridgeEnum] = None
    is_priority: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isPriority")] = pydantic.Field(
        default=None
    )
    """
    True for priority log streams, false for non-priority
    """

    filters: typing.Optional[typing.List[LogStreamFilter]] = pydantic.Field(default=None)
    """
    Only logs events matching these filters will be delivered by the stream. If omitted or empty, all events will be delivered.
    """

    pii_config: typing.Optional[LogStreamPiiConfig] = None
    sink: typing.Optional[LogStreamEventBridgeSink] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
